/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.content.Context;
import android.os.SystemClock;
import android.util.Log;
import com.gprinter.bean.PrinterDevices;
import com.gprinter.io.PortManager;
import com.gprinter.udp.UdpCallBack;
import com.gprinter.udp.UdpCommand;
import com.gprinter.udp.ethernet.EthernetDeviceResp;
import com.gprinter.udp.ethernet.RebootCommand;
import com.gprinter.udp.ethernet.SearchDeviceCommand;
import com.gprinter.udp.ethernet.SettingDHCPCommand;
import com.gprinter.udp.ethernet.SettingGatewayCommand;
import com.gprinter.udp.ethernet.SettingIPCommand;
import com.gprinter.udp.ethernet.SettingNetmaskCommand;
import com.gprinter.utils.CallbackListener;
import com.gprinter.utils.ConvertUtils;
import com.gprinter.utils.LogUtils;
import com.gprinter.utils.NetworkUtils;
import com.gprinter.utils.SDKUtils;
import com.gprinter.utils.ThreadScheduler;
import com.gprinter.utils.UIThreadManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class UdpPort
extends PortManager {
    private Context context;
    private boolean isConnected;
    private DatagramSocket client;
    private DatagramPacket receivePacket;
    private ReceiveData receiveData;
    private CallbackListener callbackListener;
    private SearchDeviceCommand searchDeviceCommand;
    private int REMOTE_PORT;
    private String REMOTE_IP;
    private static final int BUFFER_LENGTH = 2048;
    private byte[] receiveByte = new byte[2048];
    private static final String TAG = UdpPort.class.getSimpleName();
    PrinterDevices device = null;
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final Object lock = new Object();

    public UdpPort(PrinterDevices device) {
        this.context = device.getContext();
        this.callbackListener = device.getCallbackListener();
        if (device != null) {
            this.device = device;
        }
        this.REMOTE_IP = device.getIp();
        this.REMOTE_PORT = device.getPort();
    }

    public UdpPort(Context context, CallbackListener callbackListener) {
        this.context = context;
        this.callbackListener = callbackListener;
        this.REMOTE_IP = "255.255.255.255";
        this.REMOTE_PORT = 3000;
    }

    @Override
    public boolean openPort() {
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    UdpPort.this.callbackListener.onConnecting();
                }
            });
        }
        return this.connect();
    }

    public boolean connect() {
        block8: {
            if (this.client != null) {
                return false;
            }
            if (!NetworkUtils.isWifiConnected(this.context)) {
                this.setConnected(false);
                if (this.callbackListener != null) {
                    UIThreadManager.onUIThread(new Runnable(){

                        @Override
                        public void run() {
                            UdpPort.this.callbackListener.onFailure();
                        }
                    });
                }
                return false;
            }
            try {
                this.client = new DatagramSocket(this.REMOTE_PORT);
                if (this.receivePacket == null) {
                    this.receivePacket = new DatagramPacket(this.receiveByte, 2048);
                }
                this.receiveData = new ReceiveData();
                this.receiveData.start();
                this.setConnected(true);
                if (this.callbackListener != null) {
                    if (this.callbackListener != null) {
                        UIThreadManager.onUIThread(new Runnable(){

                            @Override
                            public void run() {
                                UdpPort.this.callbackListener.onSuccess(UdpPort.this.device);
                            }
                        });
                    }
                    return true;
                }
            }
            catch (SocketException e) {
                if (this.callbackListener == null) break block8;
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        UdpPort.this.callbackListener.onFailure();
                    }
                });
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean closePort() {
        try {
            this.setConnected(false);
            this.stopReceive();
            Object object = this.lock;
            synchronized (object) {
                this.receivePacket = null;
            }
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            this.context = null;
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
            return false;
        }
    }

    public void stopReceive() {
        if (this.receiveData != null && !this.receiveData.isStoped()) {
            this.receiveData.stop();
        }
    }

    public boolean write(UdpCommand command, UdpCommand.ResponseListener ResponseListener2) {
        if (this.client == null) {
            return false;
        }
        if (command instanceof SearchDeviceCommand) {
            this.searchDeviceCommand = (SearchDeviceCommand)command;
            this.searchDeviceCommand.setResponseListener(ResponseListener2);
        } else {
            this.searchDeviceCommand = null;
        }
        try {
            byte[] data = command.getCommand();
            return this.writeDataImmediately(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean writeDataImmediately(byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            InetAddress targetAddress = InetAddress.getByName(this.REMOTE_IP);
            DatagramPacket packet = new DatagramPacket(data, data.length, targetAddress, this.REMOTE_PORT);
            LogUtils.e(TAG, "UDP Send = " + new String(data) + "\thex:" + ConvertUtils.bytesToHex(data) + "\tlength = " + data.length + "\t to " + this.REMOTE_IP + ":" + this.REMOTE_PORT);
            if (this.client == null) {
                return false;
            }
            this.client.send(packet);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readImmediately(byte[] data) throws IOException {
        if (this.client != null) {
            DatagramPacket dpt;
            Object object = this.lock;
            synchronized (object) {
                dpt = this.receivePacket;
                if (dpt == null) {
                    return 0;
                }
            }
            this.client.receive(dpt);
        }
        if (this.receivePacket == null || this.receivePacket.getLength() == 0) {
            Log.e((String)TAG, (String)"\u65e0\u6cd5\u63a5\u6536UDP\u6570\u636e\u6216\u8005\u63a5\u6536\u5230\u7684UDP\u6570\u636e\u4e3a\u7a7a");
            return 0;
        }
        return this.receivePacket.getLength();
    }

    @Override
    public boolean getConnectStatus() {
        return this.isConnected;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    @Override
    public boolean setUdpPrinter(EthernetDeviceResp ethernetDeviceResp) throws IOException {
        if (ethernetDeviceResp == null) {
            Log.e((String)TAG, (String)"UDPSearchDeviceResp is mull");
            return false;
        }
        String mac = ethernetDeviceResp.getMac();
        boolean dhcp = ethernetDeviceResp.isDhcp();
        String ip = ethernetDeviceResp.getIp();
        String gateway = ethernetDeviceResp.getGateway();
        String netmask = ethernetDeviceResp.getNetmask();
        if (dhcp) {
            this.writeDataImmediately(new SettingDHCPCommand(mac, true).getCommand());
            return this.writeDataImmediately(new RebootCommand(mac).getCommand());
        }
        this.writeDataImmediately(new SettingDHCPCommand(mac, false).getCommand());
        this.writeDataImmediately(new SettingIPCommand(mac, ip).getCommand());
        this.writeDataImmediately(new SettingGatewayCommand(mac, gateway).getCommand());
        this.writeDataImmediately(new SettingNetmaskCommand(mac, netmask).getCommand());
        return this.writeDataImmediately(new RebootCommand(mac).getCommand());
    }

    @Override
    public PrinterDevices getPrinterDevices() {
        return this.device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void searchUdpPrinter(UdpCommand.ResponseListener<EthernetDeviceResp> responseListener) {
        if (this.isConnected) {
            Object object = this.lock;
            synchronized (object) {
                if (this.byteArrayOutputStream.size() > 0) {
                    this.byteArrayOutputStream.reset();
                }
            }
            this.write(new SearchDeviceCommand(), responseListener);
            if (this.searchDeviceCommand != null && this.searchDeviceCommand.getResponseListener() != null) {
                ThreadScheduler.onThreadPool(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        long endTime = SystemClock.elapsedRealtime() + 2000L;
                        int length = 0;
                        Object object = UdpPort.this.lock;
                        synchronized (object) {
                            while (endTime > SystemClock.elapsedRealtime()) {
                                try {
                                    UdpPort.this.lock.wait(500L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (UdpPort.this.byteArrayOutputStream == null || UdpPort.this.byteArrayOutputStream.size() <= 0) continue;
                                length = UdpPort.this.byteArrayOutputStream.size() + length;
                                UdpPort.this.searchDeviceCommand.resolveResponseData(1L, UdpPort.this.byteArrayOutputStream.toByteArray());
                                UdpPort.this.byteArrayOutputStream.reset();
                            }
                        }
                        if (length == 0) {
                            LogUtils.e(TAG, "no udp devices");
                            UdpPort.this.searchDeviceCommand.resolveResponseData(2L, null);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCommand(UdpCommand command, UdpCallBack callBack, long time) throws IOException {
        if (command != null) {
            this.writeDataImmediately(command.getCommand());
            long endTime = SystemClock.elapsedRealtime() + time;
            int length = 0;
            Object object = this.lock;
            synchronized (object) {
                while (endTime > SystemClock.elapsedRealtime()) {
                    try {
                        this.lock.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.byteArrayOutputStream == null || this.byteArrayOutputStream.size() <= 0) continue;
                    length = this.byteArrayOutputStream.size() + length;
                    if (callBack != null) {
                        callBack.response(command, command.resolveResponseData(1L, this.byteArrayOutputStream.toByteArray()));
                    }
                    this.byteArrayOutputStream.reset();
                }
            }
            if (length == 0) {
                LogUtils.e(TAG, "no udp devices");
                if (callBack != null) {
                    callBack.response(command, null);
                }
            }
        }
    }

    private class ReceiveData
    implements Runnable {
        private boolean stop;
        private Thread thread = new Thread(this);
        int len;

        private ReceiveData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                try {
                    Log.e((String)TAG, (String)"\u8bfb\u53d6\u6570\u636e");
                    this.len = UdpPort.this.readImmediately(null);
                    String strReceive = new String(UdpPort.this.receiveByte, 0, this.len);
                    if (this.len > 0) {
                        Log.e((String)TAG, (String)("UDP Received = " + strReceive + " from " + UdpPort.this.receivePacket.getAddress().getHostAddress() + ":" + UdpPort.this.receivePacket.getPort()));
                        final byte[] receive = SDKUtils.subBytes(UdpPort.this.receiveByte, 0, this.len);
                        UdpPort.this.byteArrayOutputStream.write(receive);
                        Object object = UdpPort.this.lock;
                        synchronized (object) {
                            UdpPort.this.lock.notifyAll();
                        }
                        Thread.sleep(10L);
                        UIThreadManager.onUIThread(new Runnable(){

                            @Override
                            public void run() {
                                UdpPort.this.callbackListener.onReceive(receive);
                            }
                        });
                    }
                    if (UdpPort.this.receivePacket == null) continue;
                    UdpPort.this.receivePacket.setLength(2048);
                }
                catch (IOException e) {
                    if (UdpPort.this.callbackListener != null) {
                        UIThreadManager.onUIThread(new Runnable(){

                            @Override
                            public void run() {
                                LogUtils.e(TAG, "\u65ad\u5f00\u8fde\u63a5");
                                UdpPort.this.callbackListener.onDisconnect();
                            }
                        });
                    }
                    UdpPort.this.closePort();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        void start() {
            this.thread.start();
        }

        void stop() {
            this.stop = true;
        }

        boolean isStoped() {
            return this.stop;
        }
    }
}

